/* - ANDetachListener -
 * Clear all the fields and disable all the controls
 *
 * Copyright 2007 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.AnalogPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.DetachListener;
import com.phidgets.event.DetachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ANDetachListener implements DetachListener {

    private JFrame appFrame;
    private JPanel channelPanel;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numChannelsTxt;
    private JCheckBox enabledArray[];
    private JSlider voltageSliderArray[];
    private JTextField voltageTxtArray[];

    public ANDetachListener(JFrame appFrame, JPanel channelPanel, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numChannelsTxt, JCheckBox enabledArray[],
            JSlider voltageSliderArray[],
            JTextField voltageTxtArray[]) {
        this.appFrame = appFrame;
        this.channelPanel = channelPanel;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numChannelsTxt = numChannelsTxt;
        this.enabledArray = enabledArray;
        this.voltageSliderArray = voltageSliderArray;
        this.voltageTxtArray = voltageTxtArray;
    }

    public void detached(DetachEvent de) {
        try {
            AnalogPhidget detached = (AnalogPhidget) de.getSource();
            attachedTxt.setText(Boolean.toString(detached.isAttached()));
            nameTxt.setText("");
            serialTxt.setText("");
            versionTxt.setText("");
            numChannelsTxt.setText("");
            int i;
            for (i = 0; i < 4; i++) {

                enabledArray[i].setSelected(false);
                enabledArray[i].setVisible(false);
                enabledArray[i].setEnabled(false);

                voltageSliderArray[i].setValue(0);
                voltageSliderArray[i].setVisible(false);
                voltageSliderArray[i].setEnabled(false);

                voltageTxtArray[i].setText("");
                voltageTxtArray[i].setVisible(false);
                voltageTxtArray[i].setEnabled(false);
            }

            channelPanel.setVisible(false);
            channelPanel.setEnabled(false);

            appFrame.setSize(357, 311);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
}
